﻿using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Controls
{
    public partial class FilterBySelectedPatient : BaseControl
    {
        public event EventHandler FilterBySelectedPatientChanged;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (UserSession.CurrentPatientId > 0)
            {
                this.Visible = true;
            }
            else
            {
                this.Visible = false;
            }

            if (!Page.IsPostBack)
            {
                //Display selected patient name       
                PATIENT p = ServiceInterfaceManager.PATIENT_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, UserSession.CurrentPatientId);
                if (p != null)
                {
                    string strName = string.Empty;

                    if (!string.IsNullOrEmpty(p.LAST_NAME) && !string.IsNullOrEmpty(p.FIRST_NAME))
                        strName = p.LAST_NAME + ", " + p.FIRST_NAME;
                    else if (!string.IsNullOrEmpty(p.LAST_NAME))
                        strName = p.LAST_NAME;
                    else if (!string.IsNullOrEmpty(p.FIRST_NAME))
                        strName = p.FIRST_NAME;

                    lblCurrentPatientName.Text = AntiXssEnc.Encoder.HtmlEncode(strName);
                }

                //Select default selection       
                if (UserSession.FilterBySelectedPatient)
                {
                    rblFilterBySelectedPatient.SelectedIndex = 1;
                }
                else
                {
                    rblFilterBySelectedPatient.SelectedIndex = 0;
                }
            }
        }

        protected void OnFilterBySelectedPatientChanged(EventArgs e)
        {
            if (FilterBySelectedPatientChanged != null)
            {
                FilterBySelectedPatientChanged(this, e);
            }
        }

        protected void RadFilterBySelectedPatient_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch (rblFilterBySelectedPatient.SelectedValue)
            {
                case "1":
                    //All       
                    UserSession.FilterBySelectedPatient = false;
                    break;
                case "2":
                    //Filter by selected patient       
                    UserSession.FilterBySelectedPatient = true;
                    break;
            }

            OnFilterBySelectedPatientChanged(e);
        }
    }
}
